class Stats extends Mutator config(PopBalloons_Playerstats);

struct Data
{
var string 	Name;
var int		Rank,
			PlayTime;
var float 	RankScore;
var bool	bHasBioRifle,
			bHasShockRifle,
			bHasPulseGun,
			bHasRazorJack,
			bHasFlakCannon,
			bHasRocketLauncher,
			bHasSniperRifle,
			bHasMinigun;
};

struct Maps
{
var String MapName;
var int NumPlayedTimes;
var bool bBeaten;
};

var config Data PlayerInfo;
var config Maps MapsInfo[512];

var bool bSaved;

function PostBeginPlay()
{
	SetTimer(1.0,True);
}

function HandleStats(String MapName, Bool bBeaten)
{
local int i;

	if (!bSaved)
		{
		for (i=0;i<512;i++)
			{
			if ( MapsInfo[i].MapName == MapName || MapsInfo[i].MapName == "" )
				{
				MapsInfo[i].MapName = MapName;
				if ( bBeaten )
					{
					MapsInfo[i].bBeaten = True;
					}
				MapsInfo[i].NumPlayedTimes++;
				i = 999;
				}
			}
		SyncDB();
		bSaved = True;
		SaveConfig();
		log("#PB# DB saved!");
		}
}

function SyncDB()
{
local Pawn P;
local int i;
local PBPRI PRI;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI = PBPRI(PlayerPawn(P).PlayerReplicationInfo);
			if ( PRI != None )
				{
				PlayerInfo.Name = PRI.PlayerName;
				PlayerInfo.Rank = PRI.Rank;
				PlayerInfo.RankScore = PRI.RankScore;
				PlayerInfo.bHasBioRifle = PRI.bHasBioRifle;
				PlayerInfo.bHasShockRifle = PRI.bHasShockRifle;
				PlayerInfo.bHasPulseGun = PRI.bHasPulseGun;
				PlayerInfo.bHasRazorJack = PRI.bHasRazorJack;
				PlayerInfo.bHasFlakCannon = PRI.bHasFlakCannon;
				PlayerInfo.bHasRocketLauncher = PRI.bHasRocketLauncher;
				PlayerInfo.bHasSniperRifle = PRI.bHasSniperRifle;
				PlayerInfo.bHasMinigun = PRI.bHasMinigun;
				log("#PB# DB synced!");
				}
			}
		}
}

function Timer()
{
local Pawn P;
local int i;
local PBPRI PRI;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI = PBPRI(PlayerPawn(P).PlayerReplicationInfo);
			if (PRI != None && !PRI.bStatsAssigned)
				{
				PRI.bStatsAssigned = True;
				PRI.Rank = PlayerInfo.Rank;
				PRI.RankScore = PlayerInfo.RankScore;
				PRI.bHasBioRifle = PlayerInfo.bHasBioRifle;
				PRI.bHasShockRifle = PlayerInfo.bHasShockRifle;
				PRI.bHasPulseGun = PlayerInfo.bHasPulseGun;
				PRI.bHasRazorJack = PlayerInfo.bHasRazorJack;
				PRI.bHasFlakCannon = PlayerInfo.bHasFlakCannon;
				PRI.bHasRocketLauncher = PlayerInfo.bHasRocketLauncher;
				PRI.bHasSniperRifle = PlayerInfo.bHasSniperRifle;
				PRI.bHasMinigun = PlayerInfo.bHasMinigun;
				}
			if (PRI != None && PRI.bStatsAssigned)
				{
				PlayerInfo.PlayTime += 1;
				PlayerInfo.Name = PRI.PlayerName;
				PlayerInfo.Rank = PRI.Rank;
				PlayerInfo.RankScore = PRI.RankScore;
				PlayerInfo.bHasBioRifle = PRI.bHasBioRifle;
				PlayerInfo.bHasShockRifle = PRI.bHasShockRifle;
				PlayerInfo.bHasPulseGun = PRI.bHasPulseGun;
				PlayerInfo.bHasRazorJack = PRI.bHasRazorJack;
				PlayerInfo.bHasFlakCannon = PRI.bHasFlakCannon;
				PlayerInfo.bHasRocketLauncher = PRI.bHasRocketLauncher;
				PlayerInfo.bHasSniperRifle = PRI.bHasSniperRifle;
				PlayerInfo.bHasMinigun = PRI.bHasMinigun;
				}
			}
		}
}

defaultproperties:
{
bSaved=False
}









